@echo off
REM ═══════════════════════════════════════════════════════════════════════
REM  DH Toolkit — Windows Installer
REM  Creates app in %USERPROFILE%\DH-Toolkit with a desktop shortcut.
REM ═══════════════════════════════════════════════════════════════════════

echo.
echo  ╔═══════════════════════════════════════════════╗
echo  ║       DH Toolkit — Windows Installer          ║
echo  ╚═══════════════════════════════════════════════╝
echo.

set INSTALL_DIR=%USERPROFILE%\DH-Toolkit
set VENV_DIR=%INSTALL_DIR%\.venv
set SCRIPT_DIR=%~dp0

REM ── Check Python ───────────────────────────────────────────────────
where python >nul 2>&1
if %ERRORLEVEL% NEQ 0 (
    echo  [!] Python not found.
    echo  [!] Please install Python 3.10+ from https://www.python.org/downloads/
    echo  [!] IMPORTANT: Check "Add Python to PATH" during installation.
    pause
    exit /b 1
)

for /f "tokens=*" %%i in ('python -c "import sys; print(f'{sys.version_info.major}.{sys.version_info.minor}')"') do set PYVER=%%i
echo  [+] Found Python %PYVER%

REM ── Copy files ─────────────────────────────────────────────────────
echo  [+] Installing to %INSTALL_DIR%...
if not exist "%INSTALL_DIR%" mkdir "%INSTALL_DIR%"
xcopy /E /Y /Q "%SCRIPT_DIR%engines" "%INSTALL_DIR%\engines\" >nul
xcopy /E /Y /Q "%SCRIPT_DIR%templates" "%INSTALL_DIR%\templates\" >nul
if not exist "%INSTALL_DIR%\static" mkdir "%INSTALL_DIR%\static"
copy /Y "%SCRIPT_DIR%app.py" "%INSTALL_DIR%\" >nul
copy /Y "%SCRIPT_DIR%passenger_wsgi.py" "%INSTALL_DIR%\" >nul
copy /Y "%SCRIPT_DIR%requirements.txt" "%INSTALL_DIR%\" >nul
echo  [+] Files copied.

REM ── Virtual environment ────────────────────────────────────────────
echo  [+] Creating virtual environment...
python -m venv "%VENV_DIR%"
"%VENV_DIR%\Scripts\pip" install --upgrade pip -q
"%VENV_DIR%\Scripts\pip" install -r "%INSTALL_DIR%\requirements.txt" -q
echo  [+] Dependencies installed.

REM ── Launcher batch ─────────────────────────────────────────────────
(
echo @echo off
echo title DH Toolkit
echo cd /d "%INSTALL_DIR%"
echo echo.
echo echo   DH Toolkit starting...
echo echo   Press Ctrl+C to stop.
echo echo.
echo "%VENV_DIR%\Scripts\python" app.py --host 127.0.0.1 --port 5000 --open-browser
echo pause
) > "%INSTALL_DIR%\DH Toolkit.bat"

REM ── Desktop shortcut ───────────────────────────────────────────────
set SHORTCUT=%USERPROFILE%\Desktop\DH Toolkit.lnk
powershell -Command "$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%SHORTCUT%'); $s.TargetPath = '%INSTALL_DIR%\DH Toolkit.bat'; $s.WorkingDirectory = '%INSTALL_DIR%'; $s.Description = 'DH Toolkit'; $s.Save()"
echo  [+] Desktop shortcut created.

echo.
echo  ══════════════════════════════════════════════════
echo   Installation complete!
echo  ══════════════════════════════════════════════════
echo.
echo   Double-click "DH Toolkit" on your desktop to launch.
echo   The app will open in your default web browser.
echo.
pause
