@echo off
REM ═══════════════════════════════════════════════════════════════════════
REM  DH Toolkit — Build Windows .exe
REM  Run on Windows with Python 3.10+.
REM  Output: dist\DH Toolkit\ containing DH Toolkit.exe
REM ═══════════════════════════════════════════════════════════════════════

echo.
echo   Building DH Toolkit Windows application...
echo.

set SCRIPT_DIR=%~dp0
pip install pyinstaller

cd /d "%SCRIPT_DIR%"

pyinstaller ^
    --name "DH Toolkit" ^
    --console ^
    --onedir ^
    --noconfirm ^
    --clean ^
    --add-data "templates;templates" ^
    --add-data "static;static" ^
    --add-data "engines;engines" ^
    --add-data "app.py;." ^
    --hidden-import=engines.gazetteer ^
    --hidden-import=engines.network ^
    --hidden-import=engines.lda ^
    --hidden-import=flask ^
    --hidden-import=numpy ^
    --hidden-import=PIL ^
    --hidden-import=PIL.Image ^
    --hidden-import=PIL.ImageDraw ^
    --hidden-import=PIL.ImageFont ^
    --collect-submodules=numpy ^
    --collect-submodules=PIL ^
    launcher.py

echo.
echo   Build complete!
echo   Executable at: dist\DH Toolkit\DH Toolkit.exe
echo.
echo   To distribute: zip the "dist\DH Toolkit" folder.
echo   Users extract it and double-click "DH Toolkit.exe".
echo.
pause
