# DH Toolkit v2.0 — Digital Humanities Visualization Suite

Interactive tools for **mapping**, **network analysis**, and **topic modelling**, built for researchers with no coding experience required.

## Features

### Mapping
- **Interactive OpenStreetMap** via Leaflet.js — zoom, pan, click markers
- **Flexible CSV input** — auto-detects Name/Place/City/Location columns, parses composite addresses ("123 Main St, Chicago, IL"), optional Lat/Lon columns
- **600+ built-in locations** — major cities, all countries, US states, German Länder, Canadian provinces, UK regions, Australian states, Indian states, Chinese provinces, Brazilian states
- **Categorical coloring** with legend from any CSV column
- **Popup metadata** — click any marker to see all CSV columns

### Network Graph
- **ForceAtlas2** force-directed layout with Barnes-Hut optimization
- **Interactive D3.js** visualization — zoom, pan, click nodes
- **Auto-detects** Source/Target columns or select manually
- **Network statistics** — degree, weighted degree, betweenness centrality
- **Node popups** with all metadata and statistics

### Topic Model (LDA)
- **Collapsed Gibbs sampling** with configurable priors
- **Three-panel interactive explorer**:
  - Left: topic words with bar chart
  - Center: ranked documents for selected topic
  - Right: scrollable document text viewer
- **Export** full results as JSON

## Quick Start

```bash
pip install flask numpy Pillow
python app.py
```

Opens at http://localhost:5000 with auto-browser launch.

## Installation

### macOS (14+ Sonoma / Sequoia / Tahoe 26.1)
```bash
./install_macos.sh
```
Creates a double-clickable "DH Toolkit.app" in ~/Applications.

### Windows
```
install_windows.bat
```
Double-click to run. Creates desktop shortcut. Requires Python 3.10+ (prompts to install if missing).

### Linux (desktop or server)
```bash
./install_linux.sh
```
Creates desktop entry and launcher script. Also detects cPanel.

### cPanel Web Hosting
Upload files, then use **Setup Python App** in cPanel:
- Application root: `dh-toolkit`
- Startup file: `passenger_wsgi.py`
- Entry point: `application`

Install deps via the app terminal: `pip install -r requirements.txt`

## Input Formats

### Map CSV
Any CSV with a name/place column. Optional lat/lon. All other columns become popup metadata.

### Network CSV
Source + Target columns (auto-detected). Optional Weight. Extra columns become node metadata.

### Topic Model
Multiple .txt files (one per document) or a .zip containing .txt files.

## Dependencies
- Python 3.10+
- Flask, NumPy, Pillow (server-side)
- Leaflet.js, D3.js (loaded from CDN client-side)

## License
MIT. Map tiles © OpenStreetMap contributors.
